/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.Validator;
import com.ibm.hwmca.fw.servlet.pmod.util.DateFormatter;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class DateValidator
extends Validator {
    private static final String TRACE_MASKT = "XPMNVDAT";
    private static final String TRACE_MASKF = "XPMNVDAF";
    protected Date earliest = null;
    protected Date latest = null;

    public void setEarliest(Date earliest) {
        Trace.trace(TRACE_MASKF, "DateValidator.setEarliest(" + earliest + ")");
        this.earliest = earliest;
    }

    public void setLatest(Date latest) {
        Trace.trace(TRACE_MASKF, "DateValidator.setLatest(" + latest + ")");
        this.latest = latest;
    }

    private Date formDate(String rawString) throws ParseException {
        try {
            return DateFormatter.convertStringToDate(rawString);
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse: " + rawString, 0);
        }
    }

    private Date formDate(Calendar calendar) throws ParseException {
        return calendar.getTime();
    }

    public void validate(Object value) throws ValidationException {
        Trace.trace(TRACE_MASKF, "DateValidator.validate(" + value + ")");
        if (value != null) {
            Date candidate;
            block9: {
                candidate = null;
                try {
                    if (value instanceof Date) {
                        candidate = (Date)value;
                        break block9;
                    }
                    if (value instanceof Calendar) {
                        candidate = this.formDate((Calendar)value);
                        break block9;
                    }
                    if (value instanceof String) {
                        candidate = this.formDate((String)value);
                        break block9;
                    }
                    Trace.trace(TRACE_MASKF, "DateValidator.validate(" + value + ") rejected (unhandleable)");
                    throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "DateUnableToHandle", new Object[]{value.getClass().toString()}));
                }
                catch (ParseException e) {
                    Trace.trace(TRACE_MASKF, "DateValidator.validate(" + candidate + ") rejected (parse)");
                    throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "DateFailedToParse"));
                }
            }
            if (this.latest != null && candidate.after(this.latest)) {
                Trace.trace(TRACE_MASKF, "DateValidator.validate(" + candidate + ") rejected (beyond)");
                throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "DateAfter"));
            }
            if (this.earliest != null && candidate.before(this.earliest)) {
                Trace.trace(TRACE_MASKF, "DateValidator.validate(" + candidate + ") rejected (before)");
                throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "DateBefore"));
            }
        } else {
            Trace.trace(TRACE_MASKF, "DateValidator.validate(" + value + ") accepted (null)");
            return;
        }
        Trace.trace(TRACE_MASKF, "DateValidator.validate(" + value + ") accepted");
    }
}

